function RNLTV_denoising_Fig15_fingerprint
%
%setup the path
curDir=pwd; %Identify current folder

addessFolder = strjoin({curDir,'img_png_NLTV'},filesep);
path(addessFolder,path);

application.name = 'denoising';

ExpFolderName = 'results';

% PreProcessing folder
appDataFolder = ['PreProcess',upper(application.name(1)),...
    application.name(2:end),'Data'];
preprocessDataFolderPath = strjoin({curDir,appDataFolder},filesep);


ExpFolderPath = strjoin({curDir,ExpFolderName,application.name},filesep);
if ~exist(ExpFolderPath , 'dir')
    mkdir(ExpFolderPath );
end

fileName_array = {'fingerprint2120' };

nbIter = 600;
radius = 5;
init = 3;

application.data_term = 1;

% gama = 0.8;
lambda = 1;
mu=0.6;
hsigma=0.05;

sigm_array= [0.1 0.16 0.2];

for i_fileName = 1:length(fileName_array)
    fileName = fileName_array{i_fileName};
    
    ExpSubfolderPath = strjoin({ExpFolderPath,fileName},filesep);
    if ~exist( ExpSubfolderPath, 'dir')
        mkdir( ExpSubfolderPath);
    end
    
    polSubFolderPath =strjoin({ExpSubfolderPath,'pol'},filesep);
    if ~exist( polSubFolderPath, 'dir')
        mkdir( polSubFolderPath);
    end
    
    % load in_clean
    [in_clean,map] = imread([fileName,'.png']);
    in_clean = double(in_clean); in_clean = in_clean/ max(in_clean(:));
    
    for i_sigm = 1:length(sigm_array)
        
        sigm = sigm_array(i_sigm);
        
        %add noise
        tempImgName = [fileName,...
            '_sg', num2str(sigm)];
        rng(8,'twister');
        in_polluted = in_clean + sigm*randn(size(in_clean));
        if ~exist(polSubFolderPath, 'dir')
            mkdir(polSubFolderPath);
        end
        save(strjoin({polSubFolderPath,...
            [tempImgName,'_in_polluted','.mat']},filesep), 'in_polluted');
        
        switch sigm
            case 0.1
                gama = 0.8;
            case 0.16
                gama = 2.5;
            case 0.2
                gama = 4;
            otherwise
                fprintf('norecord\n');
                return
        end
        
        partialMatName = strjoin({preprocessDataFolderPath,fileName,'tv',...
            [tempImgName,'_pTV.mat']},filesep);
        load(partialMatName)
        application.init_u = u;
        
        [u,v,energies] = regularized_NLTV(in_polluted,nbIter,radius,mu,...
            lambda,gama, hsigma, init, application);
        psnr = psnr1(u,in_clean)
        
        imgResultNameFolderPath = strjoin({ExpSubfolderPath,...
            tempImgName},filesep);
        
        % save image results
        save([imgResultNameFolderPath '_u_.mat'],'u');
    end
end